/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef __web2sms_accounts_hpp__
#define __web2sms_accounts_hpp__

// Local includes
#include "providerinterface.hpp"
#include "providerinfo.hpp"
#include "accountconfig.hpp"

// Global includes
#include <QtCore/QString>
#include <QtCore/QLocale>
#include <QtXml/QDomElement>
#include <QtGui/QIcon>

// Forward declarations
class AccountsPrivate;
class Accounts;

// Type definitions
typedef QSharedPointer<Accounts> AccountsPtr;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

// TODO: This class should better be renamed to AccountManager or something like that
class PROVIDERS_API Accounts : public QObject
{
  Q_OBJECT

public:
  Accounts(QObject* parent = 0);
  ~Accounts();

  //////////////////////////////////////////////////////////////////////////
  // ### Save and Load functions
  void loadSettings();
  void saveSettings() const;

  //////////////////////////////////////////////////////////////////////////
  // ### Provider

  void loadPlugins();

  /// List the providers
  QList<ProviderInfo> providers() const;

  //////////////////////////////////////////////////////////////////////////
  // ### Accounts

  /// Add an account
  void addAccount(const AccountConfig& config);

  /// Remove an account
  void removeAccount(const QString& alias);

  /// List the accounts
  QList<AccountConfig> accounts() const;

  /// Find an account by its alias
  AccountConfig accountForAlias(const QString& alias) const;

  //////////////////////////////////////////////////////////////////////////
  // ### Account using

  ProviderInterface* providerForAlias(const QString& alias);
  ProviderInfo providerInfoForAlias(const QString& alias) const;

signals:
  void accountAdded(const AccountConfig& config);
  void accountRemoved(const AccountConfig& config);

protected:
  AccountsPrivate* d;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // __web2sms_accounts_hpp__
