/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef STARTWIDGET_HPP
#define STARTWIDGET_HPP

// Local includes
#include "providers/accounts.hpp"

// Global includes
#include <QtGui/QWidget>

// Forward declarations
class StartWidgetPrivate;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class StartWidget : public QWidget
{
  Q_OBJECT

public:
  StartWidget(QWidget* parent = 0);
  ~StartWidget();

  /// Get/Set the accounts
  void setAccounts(const AccountsPtr& accounts);
  AccountsPtr accounts() const;

signals:
  void accountClicked(const QString& alias);

private:
  StartWidgetPrivate* d;
  friend class StartWidgetPrivate;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // STARTWIDGET_HPP
