/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef MESSAGETYPE_HPP
#define MESSAGETYPE_HPP

// Local includes
#include "export.hpp"

// Global includes
#include <QtCore/QSharedDataPointer>
#include <QtCore/QMetaType>
#include <QtGui/QIcon>

// Forward declarations
class MessageTypeData;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class PROVIDERS_API MessageType
{
public:
  MessageType();
  MessageType(const MessageType& other);
  MessageType(const QString& visibleName,
              const QString& name,
              const QIcon& icon,
              const QString& information,
              int singleMessageLength,
              int maxMessageLength,
              int maxReceivers);
  ~MessageType();

  MessageType& operator=(const MessageType& other);
  bool operator==(const MessageType& other) const;

  QString visibleName() const;
  QString name() const;
  QIcon icon() const;
  QString information() const;
  int singleMessageLength() const;
  int maxMessageLength() const; // -1 == infinite
  int maxReceivers() const;

private:
  QSharedDataPointer<MessageTypeData> data;
};

//////////////////////////////////////////////////////////////////////////

Q_DECLARE_METATYPE(MessageType);

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // MESSAGETYPE_HPP
