/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef __web2sms_messagewidget_hpp__
#define __web2sms_messagewidget_hpp__

// Local includes
#include "providers/providerinterface.hpp"

// Forward declarations
class MessageWidgetPrivate;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class MessageWidget : public QWidget
{
  Q_OBJECT

public:
  MessageWidget(QWidget* parent = 0, Qt::WindowFlags f = 0);
  ~MessageWidget();

  /// Get/Set the provider
  void setProvider(ProviderInterface* provider);
  ProviderInterface* provider() const;

protected:
  MessageWidgetPrivate* d;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // __web2sms_messagewidget_hpp__
