/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

// Local includes
#include "webtexteraccountsettingsdialog.hpp"
#include "ui_webtexteraccountsettingsdialog.h"

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

struct WebTexterAccountSettingsDialogPrivate
{
  Ui_WebTexterAccountSettingsDialog ui;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

WebTexterAccountSettingsDialog::WebTexterAccountSettingsDialog(QWidget* parent /* = 0 */)
: QDialog(parent)
, d(new WebTexterAccountSettingsDialogPrivate)
{
  // Setup the ui
  d->ui.setupUi(this);
}

//////////////////////////////////////////////////////////////////////////

WebTexterAccountSettingsDialog::~WebTexterAccountSettingsDialog()
{
  delete d;
}

//////////////////////////////////////////////////////////////////////////

void WebTexterAccountSettingsDialog::setSettings(const AppSettings2& settings)
{
  // Assign the values of our settings
  // TODO: Do this in a more beautiful way than constData() and size().
  //       If we leave out the size, the string may be currupted!
  d->ui.usernameEdit->setText( QString::fromUtf8(settings.userName().constData(), settings.userName().size()) );
  d->ui.passwordEdit->setText( QString::fromUtf8(settings.password().constData(), settings.password().size()) );
  d->ui.useProxyScriptCheckBox->setChecked( settings.useProxyScript() );
  d->ui.proxyUrlEdit->setText( QString::fromUtf8(settings.proxyUrl().constData(), settings.proxyUrl().size()) );
}

//////////////////////////////////////////////////////////////////////////

AppSettings2 WebTexterAccountSettingsDialog::settings() const
{
  // Construct a new settings object
  AppSettings2 settings;
  settings.setUsername( d->ui.usernameEdit->text().toUtf8() );
  settings.setPassword( d->ui.passwordEdit->text().toUtf8() );
  settings.setUseProxyScript( d->ui.useProxyScriptCheckBox->isChecked() );
  settings.setProxyUrl( d->ui.proxyUrlEdit->text().toUtf8() );

  return settings;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
