/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef _160BY2_HPP_
#define _160BY2_HPP_

// Local includes
#include "../providerinterface.hpp"

// Forward declarations
class P160by2Private;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class P160by2 : public ProviderInterface
{
  Q_OBJECT
  Q_INTERFACES(ProviderInterface)

public:
  P160by2(QObject* parent = 0);
  ~P160by2();

  // ProviderInterface overrides
  void loadSettings(const QByteArray& data);
  QByteArray saveSettings() const;

  QList<MessageType> messageTypes() const;

  bool showAccountSettingsDialog(QWidget* parent);

  /// SendMessage returns a unique message id for this instance
  void sendMessage(const Message& message);

private:
  P160by2Private* d;
  friend class P160by2Private;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // _160BY2_HPP_
