/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef LISTPICKER_HPP
#define LISTPICKER_HPP

// Local includes
#include "export.hpp"

// Global includes
#include <QtGui/QWidget>

// Forward declarations
class ListPickerPrivate;
class QAbstractItemModel;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

/**
  * The ListPicker is a list picker widget with the same API but different
  * behaviour on some platforms.
  * Windows: QLabel + QComboBox
  * Maemo: QMaemo5ValueButton
  */
class PROVIDERS_API ListPicker : public QWidget
{
  Q_OBJECT
  Q_PROPERTY(QString text READ text WRITE setText)
  Q_PROPERTY(int currentIndex READ currentIndex WRITE setCurrentIndex)

public:
  ListPicker(QWidget* parent = 0);
  ~ListPicker();

  /// Get/Set the text
  void setText(const QString& text);
  QString text() const;

  /// Get/Set the model
  void setModel(QAbstractItemModel* model);
  QAbstractItemModel* model() const;

  /// Get/Set the current index
  void setCurrentIndex(int index);
  int currentIndex() const;

signals:
  void currentIndexChanged(int index);

private:
  ListPickerPrivate* d;
  friend class ListPickerPrivate;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // LISTPICKER_HPP
