/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef __web2sms_accountconfig_hpp__
#define __web2sms_accountconfig_hpp__

// Local includes
#include "export.hpp"

// Global includes
#include <QtCore/QSharedDataPointer>
#include <QtCore/QMetaType>
#include <QtCore/QUuid>

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class AccountConfigPrivate : public QSharedData
{
public:
  AccountConfigPrivate()
  {}

  AccountConfigPrivate(const AccountConfigPrivate& other)
    : QSharedData(other)
    , alias(other.alias)
    , providerId(other.providerId)
    , customData(other.customData)
  {}

  QString alias;
  QUuid providerId;
  QByteArray customData;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

// TODO: This should be in the .cpp file, but this gives compiler errors ... huh?
class PROVIDERS_API AccountConfig
{
public:
  AccountConfig();
  AccountConfig(const QString& alias, const QString& providerId);
  AccountConfig(const AccountConfig& other);
  ~AccountConfig();

  bool isValid() const;

  void setAlias(const QString& alias);
  QString alias() const;

  void setProviderId(const QUuid& providerId);
  QUuid providerId() const;

  void setCustomData(const QByteArray& data);
  QByteArray customData() const;

private:
  QSharedDataPointer<AccountConfigPrivate> d;
};

//////////////////////////////////////////////////////////////////////////

Q_DECLARE_METATYPE(AccountConfig);

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // __web2sms_accountconfig_hpp__
