/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef __web2sms_webtexteraccountsettingsdialog_hpp__
#define __web2sms_webtexteraccountsettingsdialog_hpp__

// Global includes
#include <QtGui/QDialog>

// Local includes
#include "appsettings.hpp"

// Forward declarations
class WebTexterAccountSettingsDialogPrivate;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class WebTexterAccountSettingsDialog : public QDialog
{
  Q_OBJECT

public:
  WebTexterAccountSettingsDialog(QWidget* parent = 0);
  ~WebTexterAccountSettingsDialog();

  /// Get/Set the settings
  void setSettings(const AppSettings2& settings);
  AppSettings2 settings() const;

protected:
  WebTexterAccountSettingsDialogPrivate* d;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // __web2sms_webtexteraccountsettingsdialog_hpp__
