/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

// Local includes
#include "message.hpp"

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

Message::Message()
{
}

//////////////////////////////////////////////////////////////////////////

Message::Message(const ContactInfoList& receivers,
                 const QString& text,
                 const MessageType& messageType)
: m_receivers(receivers)
, m_text(text)
, m_messageType(messageType)
{
}

//////////////////////////////////////////////////////////////////////////

void Message::setReceivers(const ContactInfoList& receivers)
{
  m_receivers = receivers;
}

//////////////////////////////////////////////////////////////////////////

ContactInfoList Message::receivers() const
{
  return m_receivers;
}

//////////////////////////////////////////////////////////////////////////

void Message::setText(const QString& text)
{
  m_text = text;
}

//////////////////////////////////////////////////////////////////////////

QString Message::text() const
{
  return m_text;
}

//////////////////////////////////////////////////////////////////////////

void Message::setMessageType(const MessageType& messageType)
{
  m_messageType = messageType;
}

//////////////////////////////////////////////////////////////////////////

MessageType Message::messageType() const
{
  return m_messageType;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
