/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

// Local includes
#include "accountconfig.hpp"

// Global includes
#include <QtCore/QSharedData>

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

AccountConfig::AccountConfig()
: d(new AccountConfigPrivate)
{
}

//////////////////////////////////////////////////////////////////////////

AccountConfig::AccountConfig(const QString& alias, const QString& providerId)
: d(new AccountConfigPrivate)
{
  setAlias(alias);
  setProviderId(providerId);
}

//////////////////////////////////////////////////////////////////////////

AccountConfig::AccountConfig(const AccountConfig& other)
: d(other.d)
{
}

//////////////////////////////////////////////////////////////////////////

AccountConfig::~AccountConfig()
{
}

//////////////////////////////////////////////////////////////////////////

bool AccountConfig::isValid() const
{
  return !d->alias.isEmpty() && !d->providerId.isEmpty();
}

//////////////////////////////////////////////////////////////////////////

void AccountConfig::setAlias(const QString& alias)
{
  d->alias = alias;
}

//////////////////////////////////////////////////////////////////////////

QString AccountConfig::alias() const
{
  return d->alias;
}

//////////////////////////////////////////////////////////////////////////

void AccountConfig::setProviderId(const QString& providerId)
{
  d->providerId = providerId;
}

//////////////////////////////////////////////////////////////////////////

QString AccountConfig::providerId() const
{
  return d->providerId;
}

//////////////////////////////////////////////////////////////////////////

void AccountConfig::setCustomData(const QByteArray& data)
{
  d->customData = data;
}

//////////////////////////////////////////////////////////////////////////

QByteArray AccountConfig::customData() const
{
  return d->customData;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
