/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

// Local includes
#include "messagetype.hpp"

// Global includes
#include <QtCore/QSharedData>

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class MessageTypeData : public QSharedData
{
public:
  MessageTypeData()
  {}

  MessageTypeData(const MessageTypeData& cpy)
  : QSharedData(cpy)
  , visibleName(cpy.visibleName)
  , name(cpy.name)
  , icon(cpy.icon)
  , information(cpy.information)
  , singleMessageLength(cpy.singleMessageLength)
  , maxMessageLength(cpy.maxMessageLength)
  , maxReceivers(cpy.maxReceivers)
  {}

  QString visibleName;     // tr("Extra long SMS")
  QString name;            // extralongsms
  QIcon icon;
  QString information;     // tr("You can send 500 characters for 5$")
  int singleMessageLength; // Length of "one" message
  int maxMessageLength;    // Maximum of characters that can be sent
  int maxReceivers; // Maximum number of recipients
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

MessageType::MessageType()
: data(new MessageTypeData)
{
}

//////////////////////////////////////////////////////////////////////////

MessageType::MessageType(const MessageType &rhs)
: data(rhs.data)
{
}

//////////////////////////////////////////////////////////////////////////

MessageType::MessageType(const QString& visibleName,
                         const QString& name,
                         const QIcon& icon,
                         const QString& information,
                         int singleMessageLength,
                         int maxMessageLength,
                         int maxReceivers)
: data(new MessageTypeData)
{
  data->visibleName = visibleName;
  data->name = name;
  data->icon = icon;
  data->information = information;
  data->singleMessageLength = singleMessageLength;
  data->maxMessageLength = maxMessageLength;
  data->maxReceivers = maxReceivers;
}

//////////////////////////////////////////////////////////////////////////

MessageType &MessageType::operator=(const MessageType &rhs)
{
  if (this != &rhs)
      data.operator=(rhs.data);
  return *this;
}

//////////////////////////////////////////////////////////////////////////

MessageType::~MessageType()
{
}

//////////////////////////////////////////////////////////////////////////

QString MessageType::visibleName() const
{
  return data->visibleName;
}

//////////////////////////////////////////////////////////////////////////

QString MessageType::name() const
{
  return data->name;
}

//////////////////////////////////////////////////////////////////////////

QIcon MessageType::icon() const
{
  return data->icon;
}

//////////////////////////////////////////////////////////////////////////

QString MessageType::information() const
{
  return data->information;
}

//////////////////////////////////////////////////////////////////////////

int MessageType::singleMessageLength() const
{
  return data->singleMessageLength;
}

//////////////////////////////////////////////////////////////////////////

int MessageType::maxMessageLength() const
{
  return data->maxMessageLength;
}

//////////////////////////////////////////////////////////////////////////

int MessageType::maxReceivers() const
{
  return data->maxReceivers;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
