/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

// Local includes
#include "contactsedit.hpp"

// Global includes
#include <QtGui/QTextObject>

// Define a custom data type
enum { ContactData = QTextFormat::UserProperty + 1 };

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class ContactsBlockUserData : public QTextBlockUserData
{
public:
  ContactsBlockUserData(const ContactInfo& contact)
  : contact(contact)
  {}

  ContactInfo contact;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

ContactsEdit::ContactsEdit(QWidget* parent /* = 0 */)
: QPlainTextEdit(parent)
{
  setMinimumHeight(10);

  // FIXME: Don't make this readonly
  setReadOnly(true);
}

//////////////////////////////////////////////////////////////////////////

ContactsEdit::~ContactsEdit()
{
}

//////////////////////////////////////////////////////////////////////////

void ContactsEdit::addContact(const ContactInfo& contact)
{
  QTextCursor cursor = textCursor();
  cursor.beginEditBlock();

  QTextBlock block;

  QTextCharFormat format;
  format.setProperty(ContactData, QVariant::fromValue(contact));
  format.setUnderlineStyle(QTextCharFormat::SingleUnderline);
  format.setFontWeight( QFont::Bold );

  if ( !toPlainText().isEmpty() )
    cursor.insertText(", ", QTextCharFormat());

  cursor.insertText(contact.name(), format);

  cursor.endEditBlock();
}

//////////////////////////////////////////////////////////////////////////

QList<ContactInfo> ContactsEdit::contacts() const
{
  QList<ContactInfo> contacts;

  foreach(QTextFormat format, document()->allFormats())
  {
    QVariant data = format.property(ContactData);
    if ( data.userType() == qMetaTypeId<ContactInfo>() )
      contacts << qvariant_cast<ContactInfo>(data);
  }

  return contacts;
}

//////////////////////////////////////////////////////////////////////////

QSize ContactsEdit::sizeHint() const
{
  QSize size = QPlainTextEdit::sizeHint();
  size.setHeight( 30 );
  return size;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
