/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

// Local includes
#include "createaccountdialog.hpp"
#include "ui_createaccountdialog.h"

// Global includes
#include <QtGui/QMessageBox>

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class CreateAccountDialogPrivate
{
public:
  // Properties
  Ui_CreateAccountDialog ui;

  QList<ProviderInfo> providerInfo;

  // Functions
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

CreateAccountDialog::CreateAccountDialog(QWidget* parent /* = 0 */)
: QDialog(parent)
, d(new CreateAccountDialogPrivate)
{
  d->ui.setupUi(this);
}

//////////////////////////////////////////////////////////////////////////

CreateAccountDialog::~CreateAccountDialog()
{
  delete d;
}

//////////////////////////////////////////////////////////////////////////

void CreateAccountDialog::setAlias(const QString& alias)
{
  d->ui.aliasLineEdit->setText(alias);
}

//////////////////////////////////////////////////////////////////////////

QString CreateAccountDialog::alias() const
{
  return d->ui.aliasLineEdit->text();
}

//////////////////////////////////////////////////////////////////////////

ProviderInfo CreateAccountDialog::providerInfo() const
{
  // Get the selected index
  int id = d->ui.providerComboBox->currentIndex();
  if ( id == -1 )
    return ProviderInfo();

  // Get the provider info of the given position
  return qvariant_cast<ProviderInfo>( d->ui.providerComboBox->itemData(id, Qt::UserRole) );
}

//////////////////////////////////////////////////////////////////////////

void CreateAccountDialog::setProviderInfoList(const QList<ProviderInfo>& providerInfo)
{
  // Clear the comboxbox
  d->ui.providerComboBox->clear();

  // Remember the values
  d->providerInfo = providerInfo;

  // List the provider info
  foreach(const ProviderInfo& info, providerInfo)
    d->ui.providerComboBox->addItem(info.icon, info.visibleName, QVariant::fromValue(info));
}

//////////////////////////////////////////////////////////////////////////

QList<ProviderInfo> CreateAccountDialog::providerInfoList() const
{
  return d->providerInfo;
}

//////////////////////////////////////////////////////////////////////////

void CreateAccountDialog::accept()
{
  // Make sure the alias is not empty
  if ( alias().isEmpty() )
  {
    QMessageBox::critical(this, tr("Required fields"), tr("You have to set an alias name!"));
    return;
  }

  // Make sure a provider has been selected
  if ( d->ui.providerComboBox->currentIndex() == -1 )
  {
    QMessageBox::critical(this, tr("Required fields"), tr("You have to select a provider!"));
    return;
  }

  // Close the dialog
  QDialog::accept();
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
