/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef __web2sms_accountsmodel_hpp__
#define __web2sms_accountsmodel_hpp__

// Local includes
#include "accounts.hpp"

// Global includes
#include <QtCore/QAbstractItemModel>

// Forward declarations
class AccountsModelPrivate;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class PROVIDERS_API AccountsModel : public QAbstractItemModel
{
  Q_OBJECT

public:
  AccountsModel(QObject* parent = 0);
  ~AccountsModel();

  enum AccountsModelRoles
  {
    AccountAliasRole = Qt::UserRole + 1,
    AccountProviderNameRole,
    AccountProviderIconRole,
  };

  /// Get/Set the accounts
  void setAccounts(const AccountsPtr& accounts);
  AccountsPtr accounts() const;

  // QAbstractItemModel overrides
  int columnCount(const QModelIndex& parent = QModelIndex()) const;
  int rowCount(const QModelIndex& parent = QModelIndex()) const;

  QModelIndex parent(const QModelIndex& index) const;
  QModelIndex index(int row, int column, const QModelIndex& parent = QModelIndex()) const;

  QVariant headerData(int section, Qt::Orientation orientation, int role = Qt::DisplayRole) const;
  QVariant data(const QModelIndex& index, int role = Qt::DisplayRole) const;

protected:
  AccountsModelPrivate* d;
  friend class AccountsModelPrivate;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // __web2sms_accountsmodel_hpp__
