/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef __web2sms_providerplugin_hpp__
#define __web2sms_providerplugin_hpp__

// Local includes
#include "providerinterface.hpp"

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

struct ProviderPlugin
{
  virtual ~ProviderPlugin() {}

  // Functions?
  virtual QList<ProviderInfo> info() const = 0;
  virtual ProviderInterfacePtr createProvider(const QString& name) const = 0;
};

Q_DECLARE_INTERFACE(ProviderPlugin, "org.maemo.garage.web2sms.ProviderPlugin/1.0");

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // __web2sms_providerplugin_hpp__
