/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

// Local includes
#include "contacts.h"

// Global includes
#include <QtCore/QRegExp>

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

bool make_number_international(QString& number)
{
  /// ### Convert a number to international format.
  /// ### TODO: Detect the country prefix where the mobile phone is (or the provider?)
  /// 004989xxxx stays
  /// +4989      stays
  /// 089        becomes +4989
  /// 123456     is invalid (we don't know the region, same network as the mobile could be)

  // Accepted versions (complete international)
  if ( number.startsWith("00") || number.startsWith(QLatin1Char('+')) )
    return TRUE;

  // Country-local
  if ( number.startsWith("0") )
  {
    // Insert +49 instead of the first zero. This should be changed into a all-countries
    // compatible version
    number.replace(QRegExp("^0"), "+49");
    return true;
  }

  return false;
}

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
