/*
 *
 *  Copyright (c) 2010 Christoph Keller <gri@nospam@not-censored.com>
 *
 *  This file is part of Web2SMS.
 *
 *  Web2SMS is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Web2SMS is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Web2SMS. If not, see <http://www.gnu.org/licenses/>
 *
 */

#ifndef __web2sms_o2_germany_hpp__
#define __web2sms_o2_germany_hpp__

// Local includes
#include "../providerinterface.hpp"

// Global includes
#include <QtCore/QObject>

// Forward declarations
class o2GermanyPrivate;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

class o2Germany : public ProviderInterface
{
  Q_OBJECT
  Q_INTERFACES(ProviderInterface)

public:
  o2Germany(QObject* parent = 0);
  ~o2Germany();

  // ProviderInterface overrides
  QString name() const;
  QPixmap pixmap() const;

  bool showAccountSettingsDialog(QWidget* parent);

  bool hasLoginData() const;
  bool isLoggedIn() const;

  int freeSMSCount() const;

  void login();
  void logout();

  /// SendMessage returns a unique message id for this instance
  int sendMessage(const QString& receiver, const QString& message);

private:
  o2GermanyPrivate* d;
  friend class o2GermanyPrivate;
};

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////

#endif // __web2sms_o2_germany_hpp__
