#include "savedialog.h"
#include "ui_savedialog.h"

saveDialog::saveDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::saveDialog)
{
    ui->setupUi(this);
    ui->saveBtnBox->addButton("Save", QDialogButtonBox::YesRole);
    ui->saveBtnBox->addButton("Cancel", QDialogButtonBox::NoRole);

    QRegExp nameRegExp("^[a-z0-9_-\\s]*$");
    // ^                From the beginning of the string
    // [a-z0-9_-\s]     Only lowercase alphanumeric, _ and - and whitespace
    // *                At least 0 characters
    // $                Until the end of the string
    ui->saveFileNameEdit->setValidator(new QRegExpValidator(nameRegExp, ui->saveFileNameEdit));
}

saveDialog::~saveDialog()
{
    delete ui;
}
