#include "wpmanager.h"
#include "ui_wpmanager.h"

#include <QMaemo5InformationBox>
#include <QTextStream>

wpManager::wpManager(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::wpManager)
{
    ui->setupUi(this);

    // Set the Images directory as the fixed path, filter on .desktop files
    imageSetDir.setPath("/home/user/MyDocs/.images/");
    nameFilters << "*.desktop";
    // Make a watcher for the Images directory
    watchDir.addPath(imageSetDir.absolutePath());
    connect(&watchDir, SIGNAL(directoryChanged(QString)),
            this, SLOT(updateList()));

    delDialogIsMade = false;
    fileView = filenames;
    setupWPManMenuBar();

    connect(ui->fileList, SIGNAL(itemSelectionChanged()),
            this, SLOT(itemChanged()));

    connect(ui->manPrevBtn, SIGNAL(clicked()),
            this, SLOT(updatePrevs()));
    connect(ui->manEditBtn, SIGNAL(clicked()),
            this, SLOT(editCurrent()));
    connect(ui->manDelBtn, SIGNAL(clicked()),
            this, SLOT(confirmDelSet()));

    for(i=0; i<4; i++)
        manPrev.append(new QLabel);
    manPrev[0] = ui->manPrev1;
    manPrev[1] = ui->manPrev2;
    manPrev[2] = ui->manPrev3;
    manPrev[3] = ui->manPrev4;

    updateList();

    ui->fileList->clearSelection();
    ui->fileList->setCurrentRow(0);
    ui->fileList->setCurrentItem(
            ui->fileList->item(
                    ui->fileList->currentRow())); // Set item at current row (0) as current item
    ui->fileList->currentItem()->setSelected(true);
}





wpManager::~wpManager()
{
    delete ui;
}





void wpManager::setupWPManMenuBar() {
    wpManViewNames = new QAction(tr("View names"), this);
    wpManViewFilenames = new QAction(tr("View filenames"), this);

    wpManMenu = menuBar()->addMenu("");
    wpManMenu->addAction(wpManViewNames);
    wpManMenu->addAction(wpManViewFilenames);

    connect(wpManViewNames, SIGNAL(triggered()),
            this, SLOT(viewNames()));
    connect(wpManViewFilenames, SIGNAL(triggered()),
            this, SLOT(viewFilenames()));
}





void wpManager::viewNames() {
    fileView = names;
    changeView();
}
void wpManager::viewFilenames() {
    fileView = filenames;
    changeView();
}
void wpManager::changeView() {
    for(i=0; i<imageSetList.count(); i++) {
        if(fileView == filenames)
            ui->fileList->item(i)->setText(QFileInfo(imageSetList[i][0]).fileName());
        else if(fileView == names)
            ui->fileList->item(i)->setText(imageSetList[i][5]);
    }
}





void wpManager::updateList() {
    // Before updating, save current row position
    curRowBeforeUpdate = ui->fileList->currentRow();

    // Empty the lists before updating
    imageSetPreList.clear();
    imageSetList.clear();
    ui->fileList->clear();

    // Put all the entries in Images directory (+filter) in imageSetPreList (QStringList)
    // Include hidden files
    imageSetPreList = imageSetDir.entryList(nameFilters, QDir::Files | QDir::Hidden);

    // Fill imageSetList with entries that contain "Type=Background Image"
    fillImageSetList();

    // Put (file)names in fileList
    for(i=0; i<imageSetList.count(); i++) {
        if(fileView == filenames)
            itemList.append(new QListWidgetItem(QIcon(imageSetList[i][1]), QFileInfo(imageSetList[i][0]).fileName(), ui->fileList));
        else if(fileView == names)
            itemList.append(new QListWidgetItem(QIcon(imageSetList[i][1]), imageSetList[i][5], ui->fileList));
    }

    // Clear the previews
    for(i=0; i<4; i++)
        manPrev[i]->setPixmap(QPixmap(""));

    ui->fileList->setCurrentRow(curRowBeforeUpdate);
}





void wpManager::fillImageSetList() {
    // -1 because of listIndex++, so it starts at 0
    listIndex = -1;

    for(i=0; i<imageSetPreList.length(); i++) {
        checkFile.setFileName(imageSetDir.absolutePath() + "/" + imageSetPreList[i]);
        checkFile.open(QFile::ReadOnly);

        QTextStream readCheckFile(&checkFile);
        addIt = false;

        while(!readCheckFile.atEnd()) { // Read the whole file
            lineInFile = readCheckFile.readLine();

            // Append it to imageSetList if it contains "Type=Background Image"
            if(lineInFile.startsWith("Type=Background Image", Qt::CaseSensitive))
                addIt = true;
        }

        checkFile.close();

        if(addIt == true) {
            listIndex++;
            imageSetList << QVector<QString>(); // New list in imageSetList
            imageSetList[listIndex] << QString("") // New member in freshly made list, [0] = absolute path + filename
                                    << QString("") // New member in freshly made list, [1] = x-file1
                                    << QString("") // New member in freshly made list, [2] = x-file2
                                    << QString("") // New member in freshly made list, [3] = x-file3
                                    << QString("") // New member in freshly made list, [4] = x-file4
                                    << QString(""); // New member in freshly made list, [5] = name

            // Fill imageSetList[listIndex][0], which is absolute path + filename
            imageSetList[listIndex][0] = imageSetDir.absolutePath() + "/" + imageSetPreList[i];

            checkFile.setFileName(imageSetDir.absolutePath() + "/" + imageSetPreList[i]);
            checkFile.open(QFile::ReadOnly);

            QTextStream readCheckFile(&checkFile);

            while(!readCheckFile.atEnd()) {
                lineInFile = readCheckFile.readLine();

                // Fill imageSetList[listIndex][1, 2, 3 and 4], which is X-File1, 2, 3 and 4
                for(j=1; j<5; j++) {
                    if(lineInFile.startsWith("X-File" + QString::number(j) + "=")) {
                        lineInFile.remove(0, 8);
                        imageSetList[listIndex][j] = lineInFile;
                    }
                }
                // Fill imageSetList[listIndex][5], which is the set-name
                if(lineInFile.startsWith("Name=")) {
                    lineInFile.remove(0, 5);
                    imageSetList[listIndex][5] = lineInFile;
                }

            } // End of file reading

            checkFile.close();
        } // End-if addIt == true
    } // End-for all entries in imageSetPreList
}





bool wpManager::checkSelected() {
    // If none is selected
    if(ui->fileList->currentRow() <= -1) {
        QMaemo5InformationBox::information(this,
                                           "Please select an image set from the list first",
                                           QMaemo5InformationBox::DefaultTimeout);
        return false;
    }
    else
        return true;
}





void wpManager::updatePrevs() {
    if(checkSelected() == true) {
        // Update previews with Name
        if(imageSetList[ui->fileList->currentRow()][5] == "")
            ui->manPrevName->setText("<b>" + tr("(no name)") + "</b>");
        else
            ui->manPrevName->setText("<b>" + imageSetList[ui->fileList->currentRow()][5] + "</b>");

        // Update previews with X-File#
        for(i=0; i<4; i++) {
            if(imageSetList[ui->fileList->currentRow()][i+1] == "") {
                manPrev[i]->setPixmap(QPixmap(""));
                manPrev[i]->setText(tr("(empty)"));
            }
            else if(QFile(imageSetList[ui->fileList->currentRow()][i+1]).exists() == false) {
                manPrev[i]->setPixmap(QPixmap(""));
                manPrev[i]->setText(tr("(doesn't") + "<br>" + tr("exist)"));
            }
            else
                manPrev[i]->setPixmap(QPixmap(imageSetList[ui->fileList->currentRow()][i+1]));
        }
    }
}





void wpManager::editCurrent() {
    if(checkSelected() == true) {
        // Create a new wpNew window for editing
        editWin = new wpNew(this);
        editWin->setAttribute(Qt::WA_Maemo5StackedWindow);
        editWin->setAttribute(Qt::WA_DeleteOnClose);
        connect(editWin, SIGNAL(destroyed()),
                this, SLOT(reselectAfterEdit()));

        // Pass Name to editWin::nameEdit
        editWin->ui->nameEdit->setText(imageSetList[ui->fileList->currentRow()][5]);

        // Pass X-File# through 4 to editWin::imgPath[#]
        for(i=0; i<4; i++) {
            *editWin->imgPath[i] = imageSetList[ui->fileList->currentRow()][i+1];
        }

        // Put the "Invisible file" checkbox in the right state
        if(QFileInfo(imageSetList[ui->fileList->currentRow()][0]).fileName().startsWith("."))
            editWin->ui->visibChkbox->setChecked(true);
        else
            editWin->ui->visibChkbox->setChecked(false);

        // Update previews, buttons, copytobuttons
        for(i=0; i<4; i++) {
            editWin->updateImgBtnPrev(i);
            if(QFile(*editWin->imgPath[i]).exists() == true) {
                editWin->imgPrevName[i]->setText(QFileInfo(*editWin->imgPath[i]).fileName());
                editWin->setupCopyToBtn(i);
            }
        }
        editWin->updateSaveBtn();

        // Pass the filename to editWin
        editWin->saveFileName = QFileInfo(imageSetList[ui->fileList->currentRow()][0]).fileName();

        // Before opening, save current row position
        curRowBeforeEdit = ui->fileList->currentRow();

        editWin->show();
    }
}





void wpManager::confirmDelSet() {
    if(checkSelected() == true) {
        // Store filename with path in QFile delFileWithPath
        delFileWithPath.setFileName(imageSetList[ui->fileList->currentRow()][0]);

        // Don't create another QDialog if it has been made already, just update it
        if(delDialogIsMade == false) {
            delDialog = new deleteDialog(this);

            connect(delDialog->ui->delBtnBox, SIGNAL(accepted()),
                    this, SLOT(delSet()));
            connect(delDialog->ui->delBtnBox, SIGNAL(rejected()),
                    this->delDialog, SLOT(close()));

            delDialogIsMade = true;
        }


        delDialog->ui->delText->setText(tr("Delete this file?")
                                        + "<br>"
                                        + tr("Note: images are NOT deleted.")
                                        + "<br><br>"
                                        + QFileInfo(imageSetList[ui->fileList->currentRow()][0]).fileName());
        delDialog->ui->delText->adjustSize();
        delDialog->adjustSize();
        delDialog->show();
    }
}





void wpManager::delSet() {
    // If the file is removed, show confirmation
    if(delFileWithPath.remove()) {
        delDialog->close();
        QMaemo5InformationBox::information(this,
                                           "<br>" + delFileWithPath.fileName() + "<br>"
                                           + "<b>" + tr("deleted!") + "</b><br>",
                                           QMaemo5InformationBox::NoTimeout);
    }
    // Otherwise, the file doesn't exist, or needs permission
    else
        QMaemo5InformationBox::information(this,
                                           "<br>" + tr("File is ") + "<b>" + tr("NOT") + "</b>" + tr("deleted.") + "<br>"
                                           + tr("Perhaps it is already deleted?") + "<br>"
                                           + tr("Maybe you don't have permission to open or edit the file?"),
                                           QMaemo5InformationBox::NoTimeout);
}





void wpManager::itemChanged() {
    // Clear previews to avoid confusion
    for(i=0; i<4; i++)
        manPrev[i]->setPixmap(QPixmap(""));
    ui->manPrevName->setText("");
    if(ui->fileList->currentItem()->isSelected() == false)
        ui->fileList->currentItem()->setSelected(true);
}





void wpManager::reselectAfterEdit() {
    // Reselect the row that was selected before editing
    ui->fileList->setCurrentRow(curRowBeforeEdit);
}
