#include "fourimages.h"
#include "ui_fourimages.h"
#include "wpmanager.h"
#include "ui_wpmanager.h"
#include "wallpaeper.h"
#include "ui_wallpaeper.h"

wallPaeper::wallPaeper(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::wallPaeper)
{
    ui->setupUi(this);
    this->setAttribute(Qt::WA_Maemo5StackedWindow);

    abtDialogExists = false;
    setupWPMenuBar();

    connect(ui->fourBtn, SIGNAL(clicked()),
            this, SLOT(fourBtnClicked()));
    connect(ui->manBtn, SIGNAL(clicked()),
            this, SLOT(manBtnClicked()));
}





wallPaeper::~wallPaeper()
{
    delete ui;
}





void wallPaeper::fourBtnClicked() {
    fourWin = new fourImages(this);
    fourWin->setAttribute(Qt::WA_Maemo5StackedWindow);
    fourWin->setAttribute(Qt::WA_DeleteOnClose);
    fourWin->show();
}





void wallPaeper::manBtnClicked() {
    manWin = new wpManager(this);
    manWin->setAttribute(Qt::WA_Maemo5StackedWindow);
    manWin->setAttribute(Qt::WA_DeleteOnClose);
    manWin->show();
}





void wallPaeper::setupWPMenuBar() {
    wpMenuActionAbout = new QAction(tr("About..."), this);

    wpMenu = menuBar()->addMenu("");
    wpMenu->addAction(wpMenuActionAbout);

    connect(wpMenuActionAbout, SIGNAL(triggered()),
            this, SLOT(createAbtDialog()));
}





void wallPaeper::createAbtDialog() {
    // Only create a new dialog if it hasn't been made yet
    if(abtDialogExists == false) {
        abtDialog = new aboutDialog(this);
        abtDialog->setWindowTitle("Wallpaeper 0.3.2 for Nokia N900");

        abtDialog->ui->aboutText1->adjustSize();
        abtDialog->ui->aboutText2->adjustSize();

        connect(abtDialog->ui->aboutBtnBox, SIGNAL(accepted()),
                this->abtDialog, SLOT(close()));
    }
    abtDialog->adjustSize();
    abtDialog->show();
}
