#!/usr/bin/python

USER_HOME = os.getenv("HOME")
CONFIG_FILE_PATH = USER_HOME + "/.config/wakeupcall/"
CONFIG_FILE_NAME = "wakeupcall.config.ini"
CONFIG_FILE_TEMPLATE_NAME = "wakeupcall.config.ini.template"
DATA_DIR = "/usr/share/wakeupcall/"

class Configuration:

    def __init__(self):
        self.read_configuration()

    def read_configuration(self):
        configFile = os.path.join(CONFIG_FILE_PATH, CONFIG_FILE_NAME)
        if not os.path.exists(CONFIG_FILE_PATH):
            os.makedirs(CONFIG_FILE_PATH)
	    shutil.copy(os.path.join(DATA_DIR, CONFIG_FILE_TEMPLATE_NAME), configFile)
        self.configuration = ConfigParser.ConfigParser()
        self.configuration.read(configFile)
        try:
            self.volume = self.configuration.getint("Settings", "volume")
        except ConfigParser.NoOptionError, e:
            self.volume = 90 # default
        try:
            self.fullscreen = self.configuration.getboolean("Settings", "fullscreen")
        except ConfigParser.NoOptionError, e:
            self.fullscreen = True # default
        try:
            self.screenalwayson = self.configuration.getboolean("Settings", "screenalwayson")
        except ConfigParser.NoOptionError, e:
            self.screenalwayson = False # default
        try:
            self.showdate = self.configuration.getboolean("Settings", "showdate")
        except ConfigParser.NoOptionError, e:
            self.showdate = False # default
        try:
            self.autostopalarm = self.configuration.getboolean("Settings", "autostopalarm")
        except ConfigParser.NoOptionError, e:
            self.autostopalarm = True # default
        try:
            self.soundpath = self.configuration.get("Settings", "soundpath")
        except ConfigParser.NoOptionError, e:
            self.soundpath = "http://www.wdr.de/wdrlive/media/mp3/wdr5.m3u" # default
        try:
            self.backuppath = self.configuration.get("Settings", "backuppath")
        except ConfigParser.NoOptionError, e:
            self.backuppath = "/usr/share/wakeupcall/default/alarm.mp3" # default
        try:
            self.themepath = self.configuration.get("Settings", "themepath")
        except ConfigParser.NoOptionError, e:
            self.themepath = "/usr/share/wakeupcall/default/" # default
        try:
            self.usebrightnesssensor = self.configuration.getboolean("Settings", "usebrightnesssensor")
        except ConfigParser.NoOptionError, e:
            self.usebrightnesssensor = True # default

    def write_configuration(self):
        configFile = open(os.path.join(CONFIG_FILE_PATH, CONFIG_FILE_NAME), "w")
        self.configuration.set("Settings", "volume", self.volume)
        self.configuration.set("Settings", "fullscreen", self.fullscreen)
        self.configuration.set("Settings", "screenalwayson", self.screenalwayson)
        self.configuration.set("Settings", "showdate", self.showdate)
        self.configuration.set("Settings", "autostopalarm", self.autostopalarm)
        self.configuration.set("Settings", "themepath", self.themepath)
        self.configuration.set("Settings", "backuppath", self.backuppath)
        self.configuration.set("Settings", "usebrightnesssensor", self.usebrightnesssensor)
        self.configuration.set("Settings", "soundpath", self.soundpath)
        self.configuration.write(configFile)
        configFile.close()

