/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of vumeter.
 *
 *  vumeter is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  vumeter is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with vumeter.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QColor>
#include <QDialog>
#include <QString>

namespace Ui {
    class SettingsDialog;
}

class SettingsDialog : public QDialog
{
    Q_OBJECT

public:
    explicit SettingsDialog(QWidget *parent = 0);
    ~SettingsDialog();

    static QString AUTO_ROTATE;

    static QString COLOR_SCALE;
    static QString COLOR_LOWER_THRESHOLD;
    static QString COLOR_UPPER_THRESHOLD;
    static QString COLOR_LOWER_COLOR;
    static QString COLOR_MID_COLOR;
    static QString COLOR_UPPER_COLOR;

    static QString METER;

    static QString TRIGGER;
    static QString TRIGGER_COMMAND;
    static QString TRIGGER_COUNT;
    static QString TRIGGER_VALUE;

    void accept();

private:
    Ui::SettingsDialog *ui;

};

#endif // SETTINGSDIALOG_H
