#include "settingsdialog.h"
#include "ui_settingsdialog.h"

#include <QSettings>

QString SettingsDialog::TRIGGER = "trigger";
QString SettingsDialog::TRIGGER_COMMAND = SettingsDialog::TRIGGER + "/command";
QString SettingsDialog::TRIGGER_VALUE = SettingsDialog::TRIGGER + "/value";

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);

    QSettings settings;

    ui->triggerValueEdit->setValue(settings.value(SettingsDialog::TRIGGER_VALUE, 0).toInt());
    ui->triggerCommandEdit->setText(settings.value(SettingsDialog::TRIGGER_COMMAND, "").toString());
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::accept(){
    QSettings settings;

    settings.setValue(SettingsDialog::TRIGGER_VALUE, ui->triggerValueEdit->value());
    settings.setValue(SettingsDialog::TRIGGER_COMMAND, ui->triggerCommandEdit->text());

    settings.sync();

    done(1);
}
