/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of vumeter.
 *
 *  vumeter is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  vumeter is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with vumeter.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "volumemeterwidget.h"

#include <QPen>
#include <QRect>

VolumeMeterWidget::VolumeMeterWidget(QWidget *parent) :
    QGLWidget(QGLFormat(QGL::SampleBuffers), parent)
{
    currentValue = 0;
    background = NULL;
    setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
}

void VolumeMeterWidget::initPainter(QPainter *painter){
    painter->setRenderHint(QPainter::Antialiasing, true);

    float h = height();
    float w = width();

    if(w > (RATIO * h)){
        w = RATIO * h;
    }else{
        h = w / RATIO;
    }

    painter->setViewport(0, 0, w, h);
    painter->setWindow(0, 0, w, h);
}

void VolumeMeterWidget::mouseReleaseEvent(QMouseEvent */*event*/){
    emit clicked();
}

void VolumeMeterWidget::paintEvent(QPaintEvent */*event*/){
    QPainter painter(this);

    initPainter(& painter);

    draw(& painter);
}

void VolumeMeterWidget::resizeEvent(QResizeEvent */*event*/){
    background = NULL;
}

void VolumeMeterWidget::setDbUnit(bool b){
    dbUnit = b;
    currentValue = 0;
    background = NULL;
    emit update();
}

void VolumeMeterWidget::updateValue(int value){
    currentValue = value;
    emit update();
}
