/*
 *  Copyright 2010, 2011 Ruediger Gad
 *
 *  This file is part of vumeter.
 *
 *  vumeter is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  vumeter is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with vumeter.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "pa_utils.h"
#include "pulseaudioadapter.h"

PulseAudioAdapter::PulseAudioAdapter (QObject *parent) :
    QObject(parent)
{
    context_create();
}

PulseAudioAdapter::~PulseAudioAdapter ()
{
    disconnectAudioStream();
    context_stop();
}

void PulseAudioAdapter::audioDataCallBack (const short *data, size_t length)
{
    emit audioDataReceived(data, (int)length);
}

void PulseAudioAdapter::connectAudioStream (const QString &device, bool stereo)
{
    connectAudioStream(device.toLocal8Bit().constData(), stereo);
}

void PulseAudioAdapter::connectAudioStream (const char *device, bool stereo)
{
    disconnectAudioStream();
    connect_to_vu_meter_stream(device, this, stereo ? 2 : 1, 1);
}

void PulseAudioAdapter::disconnectAudioStream ()
{
    disconnect_stream();
}

#if !defined(Q_WS_MAEMO_5) && !defined(Q_WS_MAEMO_6)
QStringList* PulseAudioAdapter::getAvailableSources ()
{
    return (QStringList *) get_source_names();
}
#endif
