/*
 *  Copyright 2010 Ruediger Gad
 *
 *  This file is part of vumeter.
 *
 *  vumeter is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  vumeter is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with vumeter.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QFile>
#include <QMainWindow>
#include <QProcess>
#include <QStringList>

#include "pulseaudioadapter.h"
#include "volumemeterwidget.h"

#include "ui_mainwindow.h"

class Trigger : public QObject
{
    Q_OBJECT

public:
    // Constructor, initializes transient values
    explicit Trigger (bool hi, Trigger & bro);
    ~Trigger ();

    bool checkAndFire (int volL, int volR);

public:
    // Configuration setting:
    int      value;
    int      countSetting;
    QString  command;
    bool     waitForBrother;

    static bool onEdge;
    static enum StereoMode { EITHER, LEFT, RIGHT, BOTH } stereoMode;

private:
    const bool high; // current type; true=high, false=low
    Trigger  &brother;

    // Current (transient) values:
    bool     conditionMetBefore;
    int      count;
    QProcess *process;
    bool     triggered;

private slots:
    void processFinished ();
};

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow (QWidget *parent = 0);
    ~MainWindow ();

private:
    Ui::MainWindow ui;

    PulseAudioAdapter adapter;

    int      interpolationLevel;

    bool     loggingEnabled;
    QString  logFileName;
    QFile    *logFile;
    long     logIndex;

    int      minVol;
    int      maxVol;

#if !defined(Q_WS_MAEMO_5) && !defined(Q_WS_MAEMO_6)
    QStringList sources;
#endif

    bool     stereo;
    bool     stereoReal;

    int      scale;  // 0=Linear, 1=dB

    Trigger  triggerHigh;
    Trigger  triggerLow;

    VolumeMeterWidget *volumeMeterLeft;
    VolumeMeterWidget *volumeMeterRight;

protected:
    virtual void closeEvent (QCloseEvent *event);

private:
    void applySettings (bool startup);
    void closeFile (QFile *file);
    void openLogFile ();
    void resetLabels ();
    void setSourceVirgin (int index);
    void setFullScreen (bool enable);

private slots:
    void resetMinValue ();
    void resetMaxValue ();
    void updateValues (const short *values, int length);

    void settingsDialog ();
    void helpDialog ();
    void aboutDialog ();

    void setMeter (int selected);
    void setScale (int selected);
    void setStereo (int selected);
    void setSource (int selected);

    void toggleFullScreen ();
};

#endif // MAINWINDOW_H
