/*
 * This file is part of vpngui
 *
 * Copyright © 2009 Nokia Corporation and/or its subsidiary(-ies)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */


#ifndef VPNGUI_PLUGIN_H
#define VPNGUI_PLUGIN_H

#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

#define VPNGUI_TYPE_PLUGIN            (vpngui_plugin_get_type ())
#define VPNGUI_PLUGIN(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), VPNGUI_TYPE_PLUGIN, PluginInfo))
#define VPNGUI_PLUGIN_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), VPNGUI_TYPE_PLUGIN, PluginInfoClass))
#define VPNGUI_IS_PLUGIN(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VPNGUI_TYPE_PLUGIN))
#define VPNGUI_IS_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VPNGUI_TYPE_PLUGIN))
#define VPNGUI_PLUGIN_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), VPNGUI_TYPE_PLUGIN, PluginInfoClass))

#include <libosso.h>
#include <gconf/gconf-client.h>

#include "vpn_notify.h"

#define ICON_ACTIVE "/usr/share/pixmaps/hiro-vpn/vpngui-on.png"
#define ICON_INACTIVE "/usr/share/pixmaps/hiro-vpn/vpngui-off.png"
#define ICON_SUSPENDED "/usr/share/pixmaps/hiro-vpn/vpngui-pending.png"
#define ICON_ACTIVE_SMALL "/usr/share/pixmaps/hiro-vpn/vpngui-on-small.png"
#define ICON_SUSPENDED_SMALL "/usr/share/pixmaps/hiro-vpn/vpngui-pending-small.png"
#define VPNC_CONNECT "sudo /usr/sbin/vpngui-helper connect"
#define VPNC_DISCONNECT "sudo /usr/sbin/vpngui-helper disconnect"

/* gconf paths */
#define VPN_GCONF_PATH "/apps/osso/vpngui/ap"
#define VPN_GCONF_AP_PATH VPN_GCONF_PATH "/%s"
#define VPN_GCONF_AP_PATH_NO VPN_GCONF_PATH "/%d"
/* allow future expansion for more than one access point */
#define VPN_GCONF_VPN_NAME VPN_GCONF_AP_PATH "/name"
#define VPN_GCONF_VPN_NAME_NO VPN_GCONF_AP_PATH_NO "/name"
#define VPN_GCONF_USER VPN_GCONF_AP_PATH "/username"
#define VPN_GCONF_PASSWD VPN_GCONF_AP_PATH "/password"
#define VPN_GCONF_PASSWD_OBF VPN_GCONF_AP_PATH "/password_obf"
#define VPN_GCONF_GWADDR VPN_GCONF_AP_PATH "/gateway"
#define VPN_GCONF_GROUP VPN_GCONF_AP_PATH "/group"
#define VPN_GCONF_SECRET VPN_GCONF_AP_PATH "/secret"
#define VPN_GCONF_SECRET_OBF VPN_GCONF_AP_PATH "/secret_obf"
#define VPN_GCONF_PROXY_TYPE VPN_GCONF_AP_PATH "/proxytype"
#define VPN_GCONF_PROXY_SERVER VPN_GCONF_AP_PATH "/proxy_server"
#define VPN_GCONF_PROXY_PORT VPN_GCONF_AP_PATH "/proxy_port"
#define VPN_GCONF_PROXY_AUTOCONFIG_URL VPN_GCONF_AP_PATH "/proxy_autoconfig_url"
#define VPN_GCONF_PROXY_IGNORE_HOSTS VPN_GCONF_AP_PATH "/proxy_ignore_hosts"

/* Placeholders */
#define VPN_GCONF_REKEY_INTERVAL VPN_GCONF_AP_PATH "/rekey_interval"
#define VPN_GCONF_NAT_KEEPALIVE VPN_GCONF_AP_PATH "/nat_keepalive"

/* Common for all connections */
//#define VPN_REKEY_INTERVAL 3000
#define VPN_REKEY_INTERVAL 17280
#define VPN_NAT_KEEPALIVE 50
#define VPN_DEFAULT_HIRO_VPN 0
#define VPNGUI_PLUGIN_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE (obj, VPNGUI_TYPE_PLUGIN, PluginInfoPrivate))
enum {
	PIXBUF_ACTIVE,
	PIXBUF_INACTIVE,
	PIXBUF_SUSPENDED,
	PIXBUF_ACTIVE_SMALL,
	PIXBUF_SUSPENDED_SMALL,
	NUM_PIXBUFS,
};

enum VpnStates {
	VPN_CONNECTING,
	VPN_CONNECTED,
	VPN_CONNECT_FAILED,
	VPN_DISCONNECTING,
	VPN_DISCONNECTED,
	VPN_DISCONNECT_FAILED,
	VPN_FORCED_DISCONNECTING,
};

/** responses emitted by the settings dialog */
enum vpn_settings_dialogs_response {
	 VPN_ACCESS_POINT_NEW,
	 VPN_ACCESS_POINT_DELETE,
	 VPN_ACCESS_POINT_SETTINGS ,
	 VPN_ACCESS_POINT_CONNECT,
	 VPN_ACCESS_POINT_CANCEL
};


typedef struct _PluginInfo        PluginInfo;
typedef struct _PluginInfoClass   PluginInfoClass;
typedef struct _PluginInfoPrivate PluginInfoPrivate;
typedef struct _PrivateVpnDetails PrivateVpnDetails;

struct _PluginInfo
{
	HDStatusMenuItem       parent;
	PluginInfoPrivate     *priv;
};

struct _PluginInfoClass
{
	HDStatusMenuItemClass  parent;
};

GType vpngui_plugin_get_type (void);

struct _PrivateVpnDetails{
	gchar *vpn_name;
	gchar *username;
	gchar *password;
	gchar *gwaddress;
	gchar *group;
	gchar *secret;
	gchar *proxytype;
	gchar *proxy_server;
	gchar *proxy_autoconfig_url;

	gboolean password_obf;
	gboolean secret_obf;
	gint proxy_port;

	GSList *proxy_ignore_hosts;
	GConfChangeSet *proxy_saved;

	int rekeyinterval;
	int natkeepalive;
};

struct _PluginInfoPrivate{
	int state;
	GtkWidget *button;
	GtkWidget *button2;  // for connect and disconnect
	GtkWidget *connect_button;  // for connect
	GtkWidget *delete_button;  // for delete
	GtkWidget *settings_button;  // for settings
	GtkWidget *menu;
	GtkWidget *menu_connect;
	GtkWidget *menu_disconnect;
	GtkWidget *menu_settings;
	GtkWidget *menu_ap;
	GtkWidget *item_ap;
	GList *list;
	GtkWidget *icon;
	GtkWidget *banner;
	GdkPixbuf *pixbuf[NUM_PIXBUFS];

	guint timer;
	gboolean have_network;

	/* vpn settings */
	PrivateVpnDetails vpn_settings;
	gchar *vpnc_config;
	gchar *old_ip;

	GPid vpnc_pid;
	guint vpnc_watch_id;
	
	gboolean show_connect_dialog;
	osso_context_t *osso_context;

	VpnNotify *vpn_notify;
	GtkDialog *main_dialog;
	int connected_vpn_ap_ui;
	int connected_vpn_ap_gconf;

	//have to remove them eventually- Rakesh
	GtkWidget* container_hbox;
	GtkWidget* vbox1;
	GtkWidget* vbox2;
	GtkWidget* sync_name_label;
	GtkWidget* prof_name_label;
	int total_items ; //Total number of VPN access points
	gboolean show_icon;
};
	
//} _PluginInfoPrivate;
void error_msg(const char *format, ...);
void set_state(PluginInfo *info, int state);

gboolean vpnc_start(PluginInfo *info);
gboolean vpnc_stop(PluginInfo *info, const gboolean forced);
gboolean vpnc_restart(PluginInfo *info);
gboolean vpnc_config_write (PluginInfo *info);

G_END_DECLS
#endif
