/*
 * This file is part of vpngui
 *
 * Copyright © 2009 Nokia Corporation and/or its subsidiary(-ies)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * */

#ifndef VPN_NOTIFY_H
#define VPN_NOTIFY_H

#include <glib-object.h>

G_BEGIN_DECLS

#define VPN_TYPE_NOTIFY \
  (vpn_notify_get_type ())
#define VPN_NOTIFY(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj), VPN_TYPE_NOTIFY, VpnNotify))
#define VPN_NOTIFY_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass), VPN_TYPE_NOTIFY, VpnNotifyClass))
#define VPN_IS_NOTIFY(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj), VPN_TYPE_NOTIFY))
#define VPN_IS_NOTIFY_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass), VPN_TYPE_NOTIFY))
#define VPN_NOTIFY_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), VPN_TYPE_NOTIFY, VpnNotifyClass))

typedef struct _VpnNotify VpnNotify;
typedef struct _VpnNotifyClass VpnNotifyClass;

struct _VpnNotify
{
  GObject parent;
};

struct _VpnNotifyClass
{
  GObjectClass parent;
};

GType vpn_notify_get_type (void);

G_END_DECLS

#endif
