/* Overload getpass(3) to make it always write to and read from stdout/stdin.
 *
 * Copyright (c) 2008 Michael "ScriptKiller" Arndt
 * http://scriptkiller.de/
 * <scriptkiller@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 */

#define _GNU_SOURCE

#include <unistd.h>
#include <stdio.h>
#include <string.h>

#define PASS_MAX 256

static char getpass_buf[PASS_MAX];

char *getpass(const char *prompt) {
  fprintf(stdout, "%s", prompt);
  fflush(stdout);
  fgets(getpass_buf, PASS_MAX-1, stdin);

  /* get rid of newline, assumes that ENTER is always pressed */
  if(strlen(getpass_buf)>0) {
    getpass_buf[strlen(getpass_buf)-1]='\0';
  }
  return getpass_buf;

}
