/* maemo vpnc-gui
 * 
 * Copyright (c) 2007 Michael "ScriptKiller" Arndt
 * http://scriptkiller.de/
 * <scriptkiller@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 */

#ifndef __CONFIG_DATA_VPNC_H__
#define __CONFIG_DATA_VPNC_H__

/** struct that describes configuration data for vpnc */
typedef struct {

  /** xauth username */
  char *xauth_user;
  /** xauth password */
  char *xauth_pw;
  /** address of ipsec gateway */
  char *ipsec_gw;
  /** ipsec ID */
  char *ipsec_id;
  /** ipsec secret */
  char *ipsec_secret;
  /** domain name */
  char *domain;
  /** use xauth interactive authentication? */
  gboolean xauth_interactive;

} config_data_vpnc;

config_data_vpnc *config_data_vpnc_alloc();
void config_data_vpnc_free(config_data_vpnc *c);

#endif
