/* maemo vpnc-gui
 * 
 * Copyright (c) 2007 Michael "ScriptKiller" Arndt
 * http://scriptkiller.de/
 * <scriptkiller@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 */

#ifndef __PROFILES_GUI_H__
#define __PROFILES_GUI_H__

#include "profile.h"

void profiles_gui_init();
void profiles_gui_new_profile();
void profiles_gui_edit_profile();
void profiles_gui_rename_profile();
void profiles_gui_delete_profile();
GtkComboBox *profiles_gui_get_combo_box();
void profiles_gui_select_profile(const gchar *profile);
void profiles_gui_set_profile_chooser_active(gboolean active);
struct profile *profiles_gui_get_selected_profile();
gboolean profiles_gui_save_profile(struct profile *p);

#endif
