/* maemo vpnc-gui
 * 
 * Copyright (c) 2007 Michael "ScriptKiller" Arndt
 * http://scriptkiller.de/
 * <scriptkiller@gmx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *
 */

/* See also: https://garage.maemo.org/svn/maemoexamples/trunk/example_gconf.c
 */

/* IMPORTS */
#include <glib.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

#include "autoconnect_gconf.h"

#define GCONF_PATH "/apps/vpnc-gui/autoconnect"
#define GCONF_CONNECTIONS_PATH "/system/osso/connectivity/IAP"
#define GCONF_PROFILE_KEY "profile"

/* (local) VARIABLES */
static GConfClient *client=NULL;

/* EXPORTS */

/**
 * Initialize gconf. This must be called
 * before any other function.
 */
void autoconnect_gconf_init() {

	if(client!=NULL)
		return;
	
	/* Get the default client */
	client=gconf_client_get_default();
	
	/* Add GConf node if absent */
	gconf_client_add_dir(client, GCONF_PATH,
			GCONF_CLIENT_PRELOAD_NONE, NULL);

}

/**
 * Return the saved profile for specified connection.
 * Non-NULL result must be freed.
 * 
 * @param conn the connection as string
 * @return the profile-name as a g_malloced string or NULL of none saved
 */
gchar *autoconnect_gconf_get_profile_for_connection(const gchar *conn) {
	
	gchar *conn_escaped=gconf_escape_key(conn, -1);
        gchar *path=g_strconcat(GCONF_PATH, "/", conn_escaped,
			"/", GCONF_PROFILE_KEY, NULL);
	g_free(conn_escaped);

	gchar *res=gconf_client_get_string(client, path, NULL);
	g_free(path);
	return res;
}

/**
 * Set a profile for the specified connection.
 * If profile is NULL then the gconf entry is removed.
 *
 * @param conn the connection as string
 * @param profile the profile-name as string or NULL
 * @return TRUE if saved successfully
 */
gboolean autoconnect_gconf_set_profile_for_connection(const gchar *conn, const gchar *profile) {
        gchar *conn_escaped=gconf_escape_key(conn, -1);
	gchar *path=g_strconcat(GCONF_PATH, "/", conn_escaped,
			"/", GCONF_PROFILE_KEY, NULL);
	g_free(conn_escaped);
	
	gboolean res;
	if(profile==NULL)
		res=gconf_client_unset(client, path, NULL);
	else
		res=gconf_client_set_string(client, path, profile, NULL);

	g_free(path);
	return res;
}

