//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef DESKTOPWIDGET_H
#define DESKTOPWIDGET_H

#include <QFrame>
#include <QGridLayout>
#include <QVBoxLayout>
#include <QLabel>
#include <QMovie>
#include <QTimer>
#include <QMouseEvent>
#include "widget/vodafonewidget.h"
#include "settings.h"
#include "settingswindow.h"

class DesktopWidget : public QFrame
{
    Q_OBJECT
public:
    explicit DesktopWidget(QWidget *parent = 0, QString appletId="", bool debug=false);
    ~DesktopWidget();

    bool x11Event(XEvent * event);

    QString GetAppletId();

private:
    bool m_Pressed;
    Settings* m_Settings;
    SettingsWindow* m_SettingsWindow;

    QString m_AppletId;
    QTimer* m_UpdateTimer;
    QMovie* m_WaitIcon;
    VodafoneWidget* m_Vodafone;
    QGridLayout* m_Layout;
    QLabel* m_lblSIM;
    QLabel* m_lblCreditoD;
    QLabel* m_lblCredito;
    QLabel* m_lblPunti;

    QFrame* m_CountersFrame;
    QVBoxLayout* m_CountersLayout;

    bool m_Updating;
    void CreateWidgets();

    void StartWaitAnimation(QLabel* label);
    void StopWaitAnimation(QLabel* label);
    bool IsNetConnected();
    void ShowSavedData();
    void SetWidgetSize();
    void CreateTimer();

signals:

public slots:
    void show();
    void settingsModified();
    void netStateChanged(QString iap, QString type, QString state, QString error);
    //void displayStateChanged(QString displayState);
    void showSettingsDialog();

    bool Update();
    bool UpdateData();

protected:
    virtual void closeEvent(QCloseEvent *event);
    virtual void mousePressEvent(QMouseEvent* event);
    virtual void mouseReleaseEvent(QMouseEvent* event);
};

#endif // DESKTOPWIDGET_H
