//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "commonstatic.h"
#include <QMessageBox>
#include <QApplication>
#include <QDesktopWidget>
#ifdef Q_WS_MAEMO_5
    #include <QDesktopServices>
    #include <QMaemo5InformationBox>
    #include <QLabel>
    #include <QVBoxLayout>
#endif
#include <QDir>

void CommonStatic::ErrorMessage(QWidget* parent, QString message)
{
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox* box = new QMaemo5InformationBox(parent);
    QObject::connect(box, SIGNAL(clicked()), box, SLOT(accept()));
    box->setTimeout(-1);

    QLabel* text = new QLabel(box);
    text->setText(message);
    text->setAlignment(Qt::AlignCenter);

    box->setWidget(text);
    box->exec();
#else
    QMessageBox msgBox(parent);
    msgBox.setIcon(QMessageBox::Critical);
    msgBox.setText(message);
    msgBox.exec();
#endif
}

void CommonStatic::InfoMessage(QWidget* parent, QString message)
{
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox* box = new QMaemo5InformationBox(parent);
    QObject::connect(box, SIGNAL(clicked()), box, SLOT(accept()));

    QLabel* text = new QLabel(box);
    text->setText(message);
    text->setAlignment(Qt::AlignCenter);

    box->setWidget(text);
    box->exec();
#else
    QMessageBox msgBox(parent);
    msgBox.setIcon(QMessageBox::Information);
    msgBox.setText(message);
    msgBox.exec();
#endif
}


bool CommonStatic::IsPortrait()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    return screenGeometry.height() > screenGeometry.width();
}

QString CommonStatic::GetHomeFolder()
{
#ifdef Q_WS_MAEMO_5
    return QDesktopServices::storageLocation(QDesktopServices::HomeLocation);
#else
    return QDir::homePath();
#endif
}

QString CommonStatic::GetSettingsFolder()
{
    return QString("%1/.vodafone190").arg(CommonStatic::GetHomeFolder());
}

QString CommonStatic::GetStylesheetFolder()
{
    return QString("%1/stylesheets").arg(GetSettingsFolder());
}

QString CommonStatic::FormatKBytes(int kbytes)
{
    float tKb = (float)kbytes;
    if (tKb/1024/1024.0 >= 1)
        return QString("%1Gb").arg(tKb / 1024.0 / 1024.0, 4, 'f', 2);
    else if (tKb/1024.0 >= 1)
        return QString("%1Mb").arg(tKb / 1024.0, 4, 'f', 2);

    return QString("%1Kb").arg(kbytes);
}

QString CommonStatic::FormatMinutes(int seconds)
{
    int mins = seconds / 60;
    int secs = seconds - mins * 60;
    return QString("%1:%2").arg(mins).arg(secs, 2, 10, QChar('0'));
}

QString CommonStatic::FormatHourMinutes(int seconds)
{
    int hh = seconds / 3600;
    int mm = (seconds - (hh * 3600)) / 60;
    QString s;
    return QString("%1:%2").arg(hh, 2, 10, QChar('0')).arg(mm, 2, 10, QChar('0'));
}

bool CommonStatic::IsMouseOver(QWidget* w)
{
    QPoint mousePos = QCursor::pos();
    QPoint widgetPos = w->mapToGlobal(QPoint(0,0));

    if (mousePos.x() >= widgetPos.x() && mousePos.x() <= widgetPos.x() + w->size().width() &&
        mousePos.y() >= widgetPos.y() && mousePos.y() <= widgetPos.y() + w->size().height())
        return true;
    return false;
}

void CommonStatic::SetSystemStylesheet(QWidget* w)
{
    w->setStyleSheet("");
}

void CommonStatic::SetDefaultStylesheet(QWidget* w)
{
    SetStylesheet(w, ":/stylesheets/Default.css");
}

void CommonStatic::SetStylesheet(QWidget* w, QString fileName)
{
    QFile* file = new QFile(fileName);
    if (file->open(QIODevice::ReadOnly | QIODevice::Text)){
        QByteArray data = file->readAll();
        QString styleSheet(data);
        w->setStyleSheet(styleSheet);
        file->close();
    }
    delete file;
}
