//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef SETTINGSWINDOW_H
#define SETTINGSWINDOW_H

#include <QMainWindow>
#include <QVBoxLayout>

#include "settings.h"
#include "widget/vodafonewidget.h"

namespace Ui {
    class SettingsWindow;
}

class SettingsWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit SettingsWindow(QWidget *parent = 0, Settings* settings=0, VodafoneWidget* vodafone=0);
    ~SettingsWindow();

private:
    Settings* m_Settings;
    Ui::SettingsWindow *ui;

    VodafoneWidget* m_Vodafone;
    QVBoxLayout* m_CountersLayout;
    QStringList GetStyleSheets();

    void CreateCountersCheckbox();

private slots:
    void SaveSlot();
    void CancelSlot();
    void StyleSlot(int index);
    void UpdateDataSlot();

signals:
    void SettingsChanged();
};

#endif // SETTINGSWINDOW_H
