//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "saldopunti.h"
#include <QStringList>

SaldoPunti::SaldoPunti(QObject *parent) :
    QObject(parent)
{
    Punti = 0;
    PuntiInScadenza = 0;
    AnnoPuntiInScadenza = 0;
}

QString SaldoPunti::ToString()
{
    return QString("%1;%2;%3;%4;%5").arg(Punti).arg(PuntiInScadenza).arg(AnnoPuntiInScadenza)
                                    .arg(Scadenza.toString("dd/MM/yyyy"))
                                    .arg(Aggiornamento.toString("dd/MM/yyyy"));
}

bool SaldoPunti::FromString(QString string)
{
    QStringList list = string.split(';');
    if (list.count() < 5)
        return false;

    Punti = list.at(0).toInt();
    PuntiInScadenza = list.at(1).toInt();
    AnnoPuntiInScadenza = list.at(2).toInt();
    Scadenza = QDate::fromString(list.at(3), "dd/MM/yyyy");
    Aggiornamento = QDate::fromString(list.at(4), "dd/MM/yyyy");

    return true;
}
