//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "counter.h"
#include <QStringList>


SogliaItem::SogliaItem()
{
    DisplayType = 0;
    Soglia = 0;
    Utilizzato = 0;
    Residuo = 0;
    Scatto = 0;
}

Counter::Counter()
{
}

QString Counter::ToString()
{
    QString result;

    result.append(QString("%1;%2;%3;%4;")
                  .arg(Description).arg(Type).arg(Class).arg(Code));

    foreach (SogliaItem s, Soglie){
        result.append(QString("%1|%2|%3|%4|%5|%6|%7|%8|%9;")
                      .arg(s.DisplayType).arg(s.Soglia).arg(s.Utilizzato)
                      .arg(s.Residuo).arg(s.Scatto).arg(s.DimensioneScatto)
                      .arg(s.Periodo.toString("dd/MM/yyyy")).arg(s.DataUtile.toString("dd/MM/yyyy"))
                      .arg(s.Unita));
    }
    return result;
}

bool Counter::FromString(QString string)
{
    QStringList list = string.split(';');
    if (list.count() < 4)
        return false;

    Description = list.at(0);
    Type = list.at(1);
    Class = list.at(2);
    Code = list.at(3);

    for (int i=4; i<list.count(); i++){
        QStringList sList = list.at(i).split('|');
        if (sList.count() < 9)
            continue;

        SogliaItem s;

        s.DisplayType = sList.at(0).toInt();
        s.Soglia = sList.at(1).toInt();
        s.Utilizzato = sList.at(2).toInt();
        s.Residuo = sList.at(3).toInt();
        s.Scatto = sList.at(4).toInt();
        s.DimensioneScatto = sList.at(5);
        s.Periodo = QDate::fromString(sList.at(6), "dd/MM/yyyy");
        s.DataUtile = QDate::fromString(sList.at(7), "dd/MM/yyyy");
        s.Unita = sList.at(8);

        Soglie.append(s);
    }
    return true;
}
