//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef SETTINGS_H
#define SETTINGS_H

#include <QObject>
#include <QSettings>
#include "saldopunti.h"
#include "counter.h"

class Settings : public QObject
{
public:
    explicit Settings(QObject *parent = 0);

    QString StyleSheetName;
    QString Username;
    QString Password;

    bool LogXml;
    bool ShowPercentage;
    bool ShowStandardCounters;

    //Sms sent counter:
    QDate SmsDate;
    int SmsSent;

    //Last data retrieved:
    QDateTime LastUpdated;
    bool ShowLastData;
    float LastCredito;
    QString LastValuta;
    SaldoPunti* LastSaldoPunti;
    QList<Counter*>* LastCounters;

    bool Load();
    bool Save();

private:
    QString GetConfigName();

};

#endif // SETTINGS_H
