//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "contactswindow.h"
#include "ui_contactswindow.h"
#include <QPushButton>
#include <QSettings>
#include <QFile>
#include "widgets/contactwidget.h"
#include "commonstatic.h"

ContactsWindow::ContactsWindow(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::ContactsWindow)
{
    ui->setupUi(this);

    m_Timer = NULL;

#ifdef Q_OS_SYMBIAN
    QAction* softKey = new QAction( tr("Indietro"), this );
    softKey->setSoftKeyRole( QAction::NegativeSoftKey );
    connect(softKey, SIGNAL(triggered()), this, SLOT(reject()));
    addAction(softKey);
#endif

#ifdef Q_WS_MAEMO_5
    ui->scrollArea->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    ui->scrollArea->setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
#endif

    if (ui->scrollAreaWidgetContents->layout() == NULL){
        QVBoxLayout* layout = new QVBoxLayout(ui->scrollAreaWidgetContents);
        ui->scrollAreaWidgetContents->setLayout(layout);
        layout->setAlignment(Qt::AlignTop);
        layout->setSpacing(0);
        layout->setContentsMargins(3,3,3,3);
    }

    ui->txtCerca->grabKeyboard();
    connect(ui->txtCerca, SIGNAL(textChanged(QString)), this, SLOT(CercaSlot()));
    connect(ui->btnClear, SIGNAL(clicked()), this, SLOT(ClearSlot()));
}

ContactsWindow::~ContactsWindow()
{
    delete ui;
}

void ContactsWindow::FillContactsList()
{
    m_Contacts = CommonStatic::ContactsCache;

#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif

    QPixmap* cImage = new QPixmap(":/images/contacts.png");
    int i = 0;
    foreach (Contact* c, m_Contacts)
        AddContactToList(c, i++, cImage);

    setWindowTitle(tr("Vodafone 190 - Rubrica (%1)").arg(m_Contacts.count()));
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void ContactsWindow::AddContactToList(Contact* c, int index, QPixmap* defaultImage)
{    
    ContactWidget* w = new ContactWidget(this, c, defaultImage);
    w->setObjectName(QString("%1").arg(index));
    connect(w, SIGNAL(clicked()), this, SLOT(SelectContactSlot()));
    ui->scrollAreaWidgetContents->layout()->addWidget(w);
}

QString ContactsWindow::GetSelectedNumber()
{
    QString res = m_Selected.trimmed();
    if (res.startsWith("+39"))
        res.remove(0, 3);
    return res;
}

void ContactsWindow::SelectContactSlot()
{
    ContactWidget* w = (ContactWidget*)sender();
    int index = w->objectName().toInt();

    Contact* c = m_Contacts.at(index);
    m_Selected = c->MobileNumber;

    accept();
}

void ContactsWindow::Init()
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
    m_Timer = new QTimer();
    m_Timer->setInterval(300);
    m_Timer->setSingleShot(true);
    connect(m_Timer, SIGNAL(timeout()), this, SLOT(TimerSlot()));
    m_Timer->start();

    ui->txtCerca->setFocus();
}

void ContactsWindow::TimerSlot()
{
    delete m_Timer;
    m_Timer = NULL;

    FillContactsList();
}

void ContactsWindow::CercaSlot()
{
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
    ui->txtCerca->setFocus();

    QWidget* child;
    int count = 0;
    for (int i=0; i<ui->scrollAreaWidgetContents->layout()->count(); i++){
        child = ui->scrollAreaWidgetContents->layout()->itemAt(i)->widget();
        if (child){
            int index = child->objectName().toInt();
            Contact* c = m_Contacts.at(index);
            if (ui->txtCerca->text().isEmpty() || c->Name.contains(ui->txtCerca->text(), Qt::CaseInsensitive)){
                child->setVisible(true);
                count++;
            }else
                child->setVisible(false);
        }
    }

    setWindowTitle(tr("Vodafone 190 - Rubrica (%1)").arg(count));
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif
}

void ContactsWindow::ClearSlot()
{
    ui->txtCerca->clear();
}
