//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "contactsloader.h"
#include <QFile>
#include <QSettings>
#include "contact.h"
#include "commonstatic.h"


bool toAscending(const Contact* s1 , const Contact* s2)
{
    return s1->Name < s2->Name;
}

void ContactsLoader::run()
{    
#ifdef Q_OS_SYMBIAN
    setStackSize(163840);
#endif
    CommonStatic::ContactsCache.clear();
    QStringList* numbers = new QStringList();

#if defined(Q_WS_MAEMO_5) || defined(Q_OS_SYMBIAN)
    //Symbian and Maemo implementation (read phonebook from phone)
    //Collect contacts from all managers:
    QContactManager* man = NULL;
    QStringList availableManagers = QContactManager::availableManagers();
    QList<QContact> contacts;
    while (!availableManagers.isEmpty()) {
        man = new QContactManager(availableManagers.takeFirst());

#ifdef Q_WS_MAEMO_5
        QList<QContact> tContacts = man->contacts();
        if (!tContacts.isEmpty()){
            contacts.append(tContacts);
            tContacts.clear();
        }
#endif

#ifdef Q_OS_SYMBIAN
        //On Symbian contacts() seems to return always an empty list, but contactsIds() seems to work fine
        QList<QContactLocalId> tContacts = man->contactIds();
        if (!tContacts.isEmpty()){
            QContact c;
            QString number;
            QContactFetchHint hint;
            hint.setOptimizationHints(QContactFetchHint::NoRelationships);
            foreach (QContactLocalId id, tContacts){
                msleep(5);
                c = man->contact(id, hint);
                if (IsContactValid(&c, &number) && !numbers->contains(number)){
                    numbers->append(number);
                    contacts.append(c);
                }
            }
            tContacts.clear();
        }        

#endif
        delete man;
        man = NULL;
    }

    numbers->clear();
    if (!contacts.isEmpty()){
        foreach (QContact c, contacts){
            msleep(5);
            QString number;
            if (IsContactValid(&c, &number) && !numbers->contains(number)){
                numbers->append(number);
                Contact* contact = new Contact();
                contact->Name = c.displayLabel();
                contact->MobileNumber = number;

                QContactThumbnail thn = c.detail(QContactThumbnail::DefinitionName);
                if (!thn.isEmpty())
                    contact->Thumbnail = new QImage(thn.thumbnail().scaled(48, 48, Qt::KeepAspectRatio));
                CommonStatic::ContactsCache.append(contact);
            }
        }
    }

#else
    // Windows implementation (read a phonebook from file)
    QString book = QString("%1/contacts.conf").arg(CommonStatic::GetSettingsFolder());
    if (!QFile::exists(book))
        return;

    QSettings* contacts = new QSettings(book, QSettings::IniFormat);

    contacts->beginGroup("Contacts");

    int max = contacts->beginReadArray("items");
    for (int i = 0; i < max; ++i) {
        msleep(10);
        contacts->setArrayIndex(i);

        Contact* contact = new Contact();
        contact->Name = contacts->value("name").toString();
        contact->MobileNumber = contacts->value("number").toString();

        CommonStatic::ContactsCache.append(contact);
    }

    contacts->endGroup();
    delete contacts;
#endif

    delete numbers;
    qSort(CommonStatic::ContactsCache.begin() , CommonStatic::ContactsCache.end(), toAscending );
}

bool ContactsLoader::IsContactValid(QContact* c, QString* number)
{
    *number = "";
    if (!c->isEmpty() && c->type() == QContactType::TypeContact){
        QList<QContactDetail> phns = c->details(QContactPhoneNumber::DefinitionName);
        foreach (QContactDetail detail, phns){
            QContactPhoneNumber* phn = (QContactPhoneNumber*)(&detail);
            QString tNumber = phn->number();
            if (phn->subTypes().contains(QContactPhoneNumber::SubTypeMobile) ||
                tNumber.startsWith("3") || tNumber.startsWith("+393")) {
                *number = tNumber;
                return true;
            }
        }
    }
    return false;
}
