//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "simwidget.h"

#include <QLabel>
#include <QMouseEvent>
#include <QStyleOption>
#include <QPainter>

#include "commonstatic.h"

SimWidget::SimWidget(QWidget *parent, QString* number) :
    QFrame(parent)
{
    Number = *number;

    m_Sunken = false;
    m_Pressed = false;
    setFrameStyle(QFrame::NoFrame | QFrame::Plain);
    setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Minimum);
#ifdef Q_OS_SYMBIAN
    setMaximumHeight(56);
#endif  
    m_Layout = new QGridLayout(this);
    m_Layout->setSpacing(3);
    m_Layout->setContentsMargins(0,0,0,0);
    this->setLayout(m_Layout);

    QPixmap* cImage = new QPixmap(":/images/sim.png");

    QLabel* lbl = new QLabel(this);
    lbl->setScaledContents(true);
    lbl->setFixedSize(48, 48);
    lbl->setPixmap(*cImage);
    m_Layout->addWidget(lbl, 0, 0, 1, 1);

    lbl = new QLabel(this);
    lbl->setText(*number);
    m_Layout->addWidget(lbl, 0, 1, 1, 1);
}

void SimWidget::mousePressEvent(QMouseEvent* event)
{
    if (event->button() == Qt::LeftButton){
        m_Pressed = true;
        m_Sunken = true;
    }
}

void SimWidget::mouseReleaseEvent(QMouseEvent*)
{
    m_Sunken = false;
    if (m_Pressed && CommonStatic::IsMouseOver(this))
        emit clicked();
}

void SimWidget::leaveEvent(QEvent*)
{
    if (m_Pressed)
        m_Sunken = false;
}

void SimWidget::enterEvent(QEvent*)
{
    if (m_Pressed)
        m_Sunken = true;
}

bool SimWidget::IsPressed(){
    return m_Sunken;
}
