//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QMenuBar>
#include <QMovie>
#include <QTimer>
#include "vodafonewidget.h"
#include "settings.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();    
    void Init();

private:
    QTimer* m_Timer;
    bool m_NoSettings;
    bool m_Closing;
    Ui::MainWindow *ui;

    QMovie* m_WaitIcon;
    Settings* m_Settings;
    QMenu* m_MainMenu;
    QAction* m_SettingsAction;
    QAction* m_AboutAction;
    QAction* m_QuitAction;
    QAction* m_UpdateAction;
    QAction* m_SelectSimAction;

    VodafoneWidget* m_Vodafone;
    QList<Counter*>* m_Counters;
    void Update();
    void closeEvent(QCloseEvent *event);
    void SetUpdatedLabel(QDateTime date);    
    void RefreshCounterWidgets();
    void ClearCounters();

private slots:
    void TimerSlot();
    void OrientationChanged();
    void SettingsSlot();
    void AboutSlot();
    void QuitSlot();
    void SmsSlot();
    void UpdateSlot();
    void SelectSIMSlot();
};

#endif // MAINWINDOW_H

