//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "contactsloader.h"
#ifdef Q_OS_SYMBIAN
    #include <applications/qtcontacts.h>
    using namespace QtMobility;
#endif
#ifdef Q_WS_MAEMO_5
    #include "qtcontacts.h"
    using namespace QtMobility;
#endif
#include <QFile>
#include <QSettings>
#include "contact.h"
#include "commonstatic.h"


bool toAscending(const Contact* s1 , const Contact* s2)
{
    return s1->Name < s2->Name;
}

void ContactsLoader::run()
{
    QList<Contact*> result;

#if defined(Q_WS_MAEMO_5) || defined(Q_OS_SYMBIAN)
    // Symbian and Maemo implementation (read phonebook from phone)
    //Collect contacts from all managers:
    QContactManager* man = NULL;
    QStringList availableManagers = QContactManager::availableManagers();
    QList<QContact> contacts;
    while (!availableManagers.isEmpty()) {
        man = new QContactManager(availableManagers.takeFirst());

#ifdef Q_WS_MAEMO_5
        if (!man->contacts().isEmpty())
            contacts.append(man->contacts());
#endif

#ifdef Q_OS_SYMBIAN
        //On Symbian contacts() seems to return always an empty list, but contactsIds() seems to work fine
        if (!man->contactIds().isEmpty()){
            QContact c;
            foreach (QContactLocalId id, man->contactIds()){
                c = man->contact(id);
                if (!c.isEmpty())
                    contacts.append(c);
            }
        }

#endif
        delete man;
        man = NULL;
    }

    if (!contacts.isEmpty()){
        foreach (QContact c, contacts){
            if (!c.isEmpty() && c.type() == QContactType::TypeContact){
                QList<QContactDetail> phns = c.details(QContactPhoneNumber::DefinitionName);
                foreach (QContactDetail detail, phns){
                    QContactPhoneNumber* phn = (QContactPhoneNumber*)(&detail);
                    QString number = phn->number();
                    if (phn->subTypes().contains(QContactPhoneNumber::SubTypeMobile) ||
                        number.startsWith("3") || number.startsWith("+393")) {
                        Contact* contact = new Contact();
                        contact->Name = c.displayLabel();
                        contact->MobileNumber = number;

                        QContactThumbnail thn = c.detail(QContactThumbnail::DefinitionName);
                        if (!thn.isEmpty())
                            contact->Thumbnail = new QImage(thn.thumbnail());
                        result.append(contact);
                    }
                }
            }
        }
    }

#else
    // Windows implementation (read a phonebook from file)
    QString book = QString("%1/contacts.conf").arg(CommonStatic::GetSettingsFolder());
    if (!QFile::exists(book))
        return;

    QSettings* contacts = new QSettings(book, QSettings::IniFormat);

    contacts->beginGroup("Contacts");

    int max = contacts->beginReadArray("items");
    for (int i = 0; i < max; ++i) {
        contacts->setArrayIndex(i);

        Contact* contact = new Contact();
        contact->Name = contacts->value("name").toString();
        contact->MobileNumber = contacts->value("number").toString();

        result.append(contact);
    }

    contacts->endGroup();
    delete contacts;
#endif
    qSort(result.begin() , result.end(), toAscending );
    CommonStatic::ContactsCache = result;
}
