//    Vodafone 190
//    Copyright (C) 2011 Paolo Iommarini
//    sakya_tg@yahoo.it
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    This program is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with this program; if not, write to the Free Software
//    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#include "captchawindow.h"
#include "ui_captchawindow.h"
#include "commonstatic.h"

CaptchaWindow::CaptchaWindow(QWidget *parent, QPixmap* captchaImage) :
    QDialog(parent),
    ui(new Ui::CaptchaWindow)
{
    ui->setupUi(this);

    ui->lblCaptcha->setPixmap(*captchaImage);

    connect(ui->btnOK, SIGNAL(clicked()), this, SLOT(OkSlot()));
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif

#ifdef Q_OS_SYMBIAN
    ui->btnOK->setVisible(false);

    QAction* softKey = new QAction( tr("Ok"), this );
    softKey->setSoftKeyRole( QAction::PositiveSoftKey );
    connect(softKey, SIGNAL(triggered()), this, SLOT(OkSlot()));
    addAction(softKey);

    softKey = new QAction( tr("Annulla"), this );
    softKey->setSoftKeyRole( QAction::NegativeSoftKey );
    connect(softKey, SIGNAL(triggered()), this, SLOT(reject()));
    addAction(softKey);
#endif

    ui->txtCaptcha->grabKeyboard();
    ui->txtCaptcha->setFocus();
}

CaptchaWindow::~CaptchaWindow()
{
    delete ui;
}

void CaptchaWindow::OkSlot()
{
    if (ui->txtCaptcha->text().isEmpty()){
        CommonStatic::ErrorMessage(this, tr("Inserire il captcha"));
        return;
    }

    m_Captcha = ui->txtCaptcha->text();
    accept();
}

QString CaptchaWindow::GetCaptcha()
{
    return m_Captcha;
}
