#include "contactwidget.h"
#include <QLabel>
#include "commonstatic.h"
#include <QStyleOption>
#include <QPainter>

ContactWidget::ContactWidget(QWidget *parent, Contact* contact, QPixmap* defaultImage) :
    QScrollArea(parent)
{
    m_Contact = contact;

    m_Sunken = false;
    m_Pressed = false;
    setFrameStyle(QFrame::NoFrame | QFrame::Plain);
    setWidgetResizable(true);
#ifdef Q_WS_MAEMO_5
    setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
#endif
    setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Minimum);

    m_Container = new QWidget(this);
    m_Container->setSizePolicy(QSizePolicy::Preferred, QSizePolicy::Maximum);
    setWidget(m_Container);

    m_Layout = new QGridLayout( m_Container );   
    m_Layout->setSpacing(3);
    m_Layout->setContentsMargins(0,0,0,0);
    m_Container->setLayout(m_Layout);

    QLabel* lbl = new QLabel(m_Container);
    lbl->setScaledContents(true);
    lbl->setMaximumSize(48, 48);
    if (m_Contact->Thumbnail != NULL)
        lbl->setPixmap(QPixmap::fromImage(*m_Contact->Thumbnail));
    else{
        QPixmap* cImage = defaultImage;
        if (cImage == NULL)
            cImage = new QPixmap(":/images/contacts.png");
        lbl->setPixmap(*cImage);
    }
    m_Layout->addWidget(lbl, 0, 0, 2, 1);

    lbl = new QLabel(m_Container);
    lbl->setText(m_Contact->Name);
    QFont f = lbl->font();
    f.setBold(true);
    lbl->setFont(f);
    m_Layout->addWidget(lbl, 0, 1, 1, 1);

    lbl = new QLabel(m_Container);
    lbl->setText(m_Contact->MobileNumber);
    m_Layout->addWidget(lbl, 1, 1, 1, 1);
}


void ContactWidget::mousePressEvent(QMouseEvent* event)
{
    if (event->button() == Qt::LeftButton){
        m_Pressed = true;
        m_Sunken = true;
    }
}

void ContactWidget::mouseReleaseEvent(QMouseEvent*)
{
    m_Sunken = false;
    if (m_Pressed && CommonStatic::IsMouseOver(this))
        emit clicked();
}

void ContactWidget::leaveEvent(QEvent*)
{
    if (m_Pressed){
        m_Sunken = false;        
    }
}

void ContactWidget::enterEvent(QEvent*)
{
    if (m_Pressed){
        m_Sunken = true;
    }
}

