#include "simswindow.h"
#include "ui_simswindow.h"

#include "widgets/simwidget.h"

SimsWindow::SimsWindow(QWidget *parent, QStringList* sims) :
    QDialog(parent),
    ui(new Ui::SimsWindow)
{
    ui->setupUi(this);

#ifdef Q_OS_SYMBIAN
    QAction* softKey = new QAction( tr("Seleziona"), this );
    softKey->setSoftKeyRole( QAction::PositiveSoftKey );
    connect(softKey, SIGNAL(triggered()), this, SLOT(accept()));
    addAction(softKey);

    softKey = new QAction( tr("Indietro"), this );
    softKey->setSoftKeyRole( QAction::NegativeSoftKey );
    connect(softKey, SIGNAL(triggered()), this, SLOT(reject()));
    addAction(softKey);
#endif

    if (ui->scrollAreaWidgetContents->layout() == NULL){
        QVBoxLayout* layout = new QVBoxLayout(ui->scrollAreaWidgetContents);
        ui->scrollAreaWidgetContents->setLayout(layout);
        layout->setAlignment(Qt::AlignTop);
        layout->setSpacing(0);
        layout->setContentsMargins(3,3,3,3);
    }

    foreach(QString sim, *sims){
        SimWidget* w = new SimWidget(this, &sim);
        connect(w, SIGNAL(clicked()), this, SLOT(SelectSimSlot()));
        ui->scrollAreaWidgetContents->layout()->addWidget(w);
    }
}

SimsWindow::~SimsWindow()
{
    delete ui;
}


QString SimsWindow::GetSelectedSim()
{
    return m_SelectedSim;
}

void SimsWindow::SelectSimSlot()
{
    m_SelectedSim = ((SimWidget*)sender())->Number;
    accept();
}
