#ifndef COMMONSTATIC_H
#define COMMONSTATIC_H
#include <QWidget>
#include <QString>
#include "widgets/contactwidget.h"

class CommonStatic
{
public:
    static QList<ContactWidget*> ContactsWidget;
    static void LoadContactsCache();

    static void ErrorMessage(QWidget* parent, QString message);
    static void InfoMessage(QWidget* parent, QString message);

    static bool IsPortrait();
    static QString GetHomeFolder();
    static QString GetSettingsFolder();
    static QString GetStylesheetFolder();
    static QString FormatKBytes(int kbytes);

    static bool IsMouseOver(QWidget* w);
    static void SetDefaultStylesheet();
    static void SetStylesheet(QString fileName);
};

#endif // COMMONSTATIC_H
