#ifndef VODAFONEWIDGET_H
#define VODAFONEWIDGET_H

#include <QDebug>
#include <QObject>
#include <QNetworkAccessManager>
#include <QUrl>
#include <QNetworkReply>
#include <QSslError>
#include <QNetworkCookieJar>
#include <QAuthenticator>
#include <QDomDocument>
#include <QEventLoop>
#include <QStringList>

#include "counter.h"
#include "saldopunti.h"
#include "infoconto.h"

// http://demos.vodafone.it/dw/getDWConfiguration.xml
// http://demos.vodafone.it/widget/contatori/getDWConfiguration.xml

//Cambio sim:
// https://widget.vodafone.it/190/trilogy/jsp/swapSim.do?ty_sim=xxxxxxxxxx

//Info conto:
// https://widget.vodafone.it/190/ebwe/mx/PushInfoconto.do?hpfdtpri=y

//Credito Residuo:
// https://widget.vodafone.it/190/fast/mx/CreditoResiduoPush.do?hpfdtpri=y

//Elenco contatori:
// https://widget.vodafone.it/190/ebwe/mx/Desktopwidgetconto.do

//Dettaglio contatore:
// https://widget.vodafone.it/190/ebwe/mx/DesktopwidgetContatoreDettagli.do?ProductType=P&Classe=2&ProductCode=888

class VodafoneWidget : public QObject
{
public:
    enum SimType {
        SimUnknown,
        SimRicaricabile,
        SimContratto,
    };

    VodafoneWidget(QString username, QString password);
     ~VodafoneWidget();

    bool DebugXml;
    void SetCredentials(QString username, QString password);
    bool IsLoggedIn();
    bool Login();
    void Logout();

    QStringList GetSims();
    QString GetCurrentSim();
    SimType GetCurrentSimType();

    bool SetCurrentSim(QString sim);

    float GetCredito(QString* valuta);
    bool GetInfoConto(InfoConto* info);
    QList<Counter*>* GetListaContatori(bool includeStandard=false);
    bool GetDettaglioContatore(Counter* counter);
    bool GetSaldoPunti(SaldoPunti* saldo);

    bool PrepareMessage(QString receiver, QString message, QByteArray* captchaImage, QString* errorMessage=0);
    bool SendMessage(QString receiver, QString message, QString captcha, QString* errorMessage=0);

    void AbortRequest();

private:
    QStringList m_Sims;
    QString m_CurrentSim;
    SimType m_CurrentSimType;

    bool m_Aborting;
    QNetworkReply* m_CurrentReply;

    QString m_SessionID;
    QNetworkCookieJar* m_CookieJar;
    QNetworkAccessManager* m_Nam;

    QString m_Username;
    QString m_Password;

    QString GetReturnCode(QDomDocument doc);
    QString GetStatus(QDomDocument doc, QString* errorMessage=0);
    QNetworkRequest PrepareRequest(QUrl url, bool vodafoneUserAgent=true);
    QNetworkRequest PrepareRequest(QString url, bool vodafoneUserAgent=true);
    QString SynchRequest(QNetworkRequest* request, QUrl* redirectUrl=NULL);

    QString Decrypt(QString* crypted, QString* sessionID);
};

#endif // VODAFONEWIDGET_H
