#include "counter.h"
#include <QStringList>

Counter::Counter()
{
    SogliaDisplayType = 0;
    Soglia = 0;
    Utilizzato = 0;
    Residuo = 0;
    Scatto = 0;
}

QString Counter::ToString()
{
    return QString("%1;%2;%3;%4;%5;%6;%7;%8;%9;%10;%11;%12;%13")
           .arg(Description).arg(Type).arg(Class).arg(Code)
           .arg(SogliaDisplayType).arg(Soglia).arg(Utilizzato)
           .arg(Residuo).arg(Scatto).arg(DimensioneScatto)
           .arg(Periodo.toString("dd/MM/yyyy")).arg(DataUtile.toString("dd/MM/yyyy"))
           .arg(Unita);
}

bool Counter::FromString(QString string)
{
    QStringList list = string.split(';');
    if (list.count() < 13)
        return false;

    Description = list.at(0);
    Type = list.at(1);
    Class = list.at(2);
    Code = list.at(3);
    SogliaDisplayType = list.at(4).toInt();
    Soglia = list.at(5).toInt();
    Utilizzato = list.at(6).toInt();
    Residuo = list.at(7).toInt();
    Scatto = list.at(8).toInt();
    DimensioneScatto = list.at(9);
    Periodo = QDate::fromString(list.at(10), "dd/MM/yyyy");
    DataUtile = QDate::fromString(list.at(11), "dd/MM/yyyy");
    Unita = list.at(12);

    return true;
}
